<?php

///// 3DSecure | TABLA 4 - Json Object acctInfo

//// chAccAgeInd & chAccDate
$userInfo					= JFactory::getUser();
if ($userInfo->guest == 1) {
	$chAccAgeInd			= "01";
} 
else{
	$accountCreated			= intval( (strtotime("now") - strtotime($userInfo->registerDate))/60 );
	$nDays					= intval($accountCreated/1440);
	$dt						= new DateTime($userInfo->registerDate);
	$chAccDate				= $dt->format('Ymd');
	if ($accountCreated < 20) {
		$chAccAgeInd 		= "02";
	}
	elseif ($nDays < 30) {
		$chAccAgeInd 		= "03";
	}
	elseif ($nDays >= 30 && $nDays <= 60) {
		$chAccAgeInd 		= "04";
	}
	else {
		$chAccAgeInd 		= "05";
	}
}

//// chAccChange			| No se puede sacar este dato
// $chAccChange				= "";

//// chAccChangeInd			| No se puede sacar este dato
// $chAccChangeInd			= "";

//// chAccPwChange & chAccPwChangeInd
if ($userInfo->guest != 1) {
	if ($userInfo->resetCount != 0) {
		$dt					= new DateTime($userInfo->lastResetTime);
		$chAccPwChange		= $dt->format('Ymd');
		$passwordModified	= intval( (strtotime("now") - strtotime($userInfo->lastResetTime))/60 );
		$nDays				= intval($passwordModified/1440);
		if ($passwordModified < 20) {
			$chAccPwChangeInd	= "01";
		}
		elseif ($nDays < 30) {
			$chAccPwChangeInd	= "02";
		}
		elseif ($nDays >= 30 && $nDays <= 60) {
			$chAccPwChangeInd	= "03";
		}
		else {
			$chAccPwChangeInd	= "04";
		}
	}
}

//// nbPurchaseAccount		| DOCS: https://docs.joomla.org/Selecting_data_using_JDatabase/es
if ($userInfo->guest != 1) {
	$fechaBase				= strtotime("-6 month");
	$dt 					= new DateTime("@$fechaBase");
	$estadoCompleto			= 'F';
	$db						= JFactory::getDbo();
	$query					= $db->getQuery(true);
	$query
		->select('count(virtuemart_user_id)')
		->from($db->quoteName('#__virtuemart_orders'))
		->where($db->quoteName('virtuemart_user_id') . ' = ' . $userInfo->id . ' AND ' . $db->quoteName('order_status') . ' = ' . $db->quote($estadoCompleto) . ' AND ' . $db->quoteName('created_on') . ' > ' . $db->quote($dt->format('Y-m-d H:i:s')));
	$db->setQuery($query);
	$nbPurchaseAccount		= $db->loadResult();
}

//// provisionAttemptsDay	| No se puede sacar este dato
// $provisionAttemptsDay	= "";

//// txnActivityDay
if ($userInfo->guest != 1) {
	$fechaBase				= strtotime("-1 day");
	$dt 					= new DateTime("@$fechaBase");
	$db						= JFactory::getDbo();
	$query					= $db->getQuery(true);
	$query
		->select('count(virtuemart_user_id)')
		->from($db->quoteName('#__virtuemart_orders'))
		->where($db->quoteName('virtuemart_user_id') . ' = ' . $userInfo->id . ' AND ' . $db->quoteName('order_status') . ' = ' . $db->quote($estadoCompleto) . ' AND ' . $db->quoteName('created_on') . ' > ' . $db->quote($dt->format('Y-m-d H:i:s')));
	$db->setQuery($query);
	$txnActivityDay			= $db->loadResult();
}

//// txnActivityYear
if ($userInfo->guest != 1) {
	$fechaBase				= strtotime("-1 year");
	$dt 					= new DateTime("@$fechaBase");
	$db						= JFactory::getDbo();
	$query					= $db->getQuery(true);
	$query
		->select('count(virtuemart_user_id)')
		->from($db->quoteName('#__virtuemart_orders'))
		->where($db->quoteName('virtuemart_user_id') . ' = ' . $userInfo->id . ' AND ' . $db->quoteName('order_status') . ' = ' . $db->quote($estadoCompleto) . ' AND ' . $db->quoteName('created_on') . ' > ' . $db->quote($dt->format('Y-m-d H:i:s')));
	$db->setQuery($query);
	$txnActivityDay			= $db->loadResult();
}

//// paymentAccAge			| No se puede sacar este dato
// $paymentAccAge			= "";

//// paymentAccInd			| No se puede sacar este dato
// $paymentAccInd			= "";

//// shipAddressUsage & shipAddressUsageInd
if ($order['details']['ST']->address_1 != null) {
	$db						= JFactory::getDbo();
	$address_1				= $db->quote($order['details']['ST']->address_1);
	$address_2				= $order['details']['ST']->address_2?' = ' . $db->quote($order['details']['ST']->address_2):' is null ';
	$city					= $db->quote($order['details']['ST']->city);
	$postcode				= $db->quote($order['details']['ST']->zip);
	$country				= $db->quote($order['details']['ST']->virtuemart_country_id);
	$query					= $db->getQuery(true);
	$query
		->select($db->quoteName('created_on'))
		->from($db->quoteName('#__virtuemart_order_userinfos'))
		->where(
			$db->quoteName('address_1') . ' = ' . $address_1 . ' AND ' .
			$db->quoteName('address_2') . $address_2 . ' AND ' .
			$db->quoteName('city') . ' = ' . $city . ' AND ' .
			$db->quoteName('zip') . ' = ' . $postcode . ' AND ' .
			$db->quoteName('virtuemart_country_id') . ' = ' . $country);
	$db->setQuery($query);
	if ($db->loadResult() != null){
		$result				= $db->loadResult();
		$dt					= new DateTime($db->loadResult());
		$shipAddressUsage	= $dt->format('Ymd');
		$nDays				= intval(((strtotime("now") - strtotime($result))/60)/1440);
		if ($nDays < 30) {
			$shipAddressUsageInd = "02";
		}
		elseif ($nDays >= 30 && $nDays <= 60) {
			$shipAddressUsageInd = "03";
		}
		else{
			$shipAddressUsageInd = "04";
		}
	}
	else {
		$fechaBase				= strtotime("now");
		$dt						= new DateTime("@$fechaBase");
		$shipAddressUsage		= $dt->format('Ymd');
		$shipAddressUsageInd	= "01";
	}
}

//// shipNameIndicator		| No se puede sacar este dato
// $shipNameIndicator		= "";

//// suspiciousAccActivity	| No se puede sacar este dato
// $suspiciousAccActivity	= "";

///// 3DSecure | FIN TABLA 4


///// 3DSecure | TABLA 1 - Ds_Merchant_EMV3DS (json Object)
//// addrMatch
if ($order['details']['ST']->address_1 != null) {
	if (
		($order['details']['ST']->address_1 == $order['details']['BT']->address_1)
		&&
		($order['details']['ST']->address_2 == $order['details']['BT']->address_2)
		&&
		($order['details']['ST']->city == $order['details']['BT']->city)
		&&
		($order['details']['ST']->zip == $order['details']['BT']->zip)
		&&
		($order['details']['ST']->virtuemart_country_id == $order['details']['BT']->virtuemart_country_id)
	) {
		$addrMatch			= "Y";
	}
	else {
		$addrMatch			= "N";
	}
}
else {
	$addrMatch				= "N";
}

//// billAddrCity
$billAddrCity 				= $order['details']['BT']->city;

//// billAddrCountry		| No se puede sacar este dato 
//$billAddrCountry 			= "";

//// billAddrLine1
$billAddrLine1 				= $order['details']['BT']->address_1;

//// billAddrLine2
$billAddrLine2				= $order['details']['BT']->address_2;

//// billAddrLine3			| No se puede sacar este dato
// $billAddrLine3			= "";

//// billAddrPostCode
$billAddrPostCode			= $order['details']['BT']->zip;

//// billAddrState			| No se puede sacar este dato
//$billAddrState			= "";

//// Email
$Email						= $order['details']['BT']->email;

//// homePhone
$homePhone					= $order['details']['BT']->phone_1 ? array("subscriber" => $order['details']['BT']->phone_1, "cc" => "34") : null;

//// mobilePhone
$mobilePhone				= $order['details']['BT']->phone_2 ? array("subscriber" => $order['details']['BT']->phone_2, "cc" => "34") : null;

//// cardholderName 		| No se puede sacar este dato
// $cardholderName			= "";

if ($order['details']['ST']->address_1 != null) {
	//// shipAddrCity
	$shipAddrCity 			= $order['details']['ST']->city;
	
	//// shipAddrCountry	| No se puede sacar este dato
	// $shipAddrCountry 	= "";
	
	//// shipAddrLine1
	$shipAddrLine1 			= $order['details']['ST']->address_1;
	
	//// shipAddrLine2
	$shipAddrLine2			= $order['details']['ST']->address_2;
	
	//// shipAddrLine3		| No se puede sacar este dato
	// $shipAddrLine3		= "";
	
	//// shipAddrPostCode
	$shipAddrPostCode		= $order['details']['ST']->zip;
	
	//// shipAddrState		| No se puede sacar este dato
	//$shipAddrState		= "";
}

//// workPhone
// $workPhone				= $homePhone;

//// threeDSRequestorAuthenticationInfo | No lo ponemos

//// acctInfo					| información de la TABLA 4
$acctInfo						= array(
	'chAccAgeInd'				=> $chAccAgeInd,
);
if ($userInfo->guest != 1) {
	$acctInfo['chAccDate']				= strval($chAccDate);
	if ($userInfo->resetCount != 0) {
		$acctInfo['chAccPwChange']		= strval($chAccPwChange);
		$acctInfo['chAccPwChangeInd']	= strval($chAccPwChangeInd);
	}
	$acctInfo['nbPurchaseAccount']		= strval($nbPurchaseAccount);
	$acctInfo['txnActivityDay']			= strval($txnActivityDay);
	$acctInfo['txnActivityYear']		= strval($txnActivityYear);
}
if ($order['details']['ST']->address_1 != null) {
	$acctInfo['shipAddressUsage']		= strval($shipAddressUsage);
	$acctInfo['shipAddressUsageInd']	= strval($shipAddressUsageInd);
}

//// purchaseInstalData		| No se puede sacar este dato
// $purchaseInstalData		= "";

//// recurringExpiry		| No se puede sacar este dato
// $recurringExpiry			= "";

//// recurringFrequency		| No se puede sacar este dato
// $recurringFrequency		= "";

//// merchantRiskIndicator	| No se puede sacar este dato
// $merchantRiskIndicator   = array();

//// challengeWindowSize	| No se puede sacar este dato
// $challengeWindowSize 	= "";


///// 3DSecure | FIN TABLA 1

///// 3DSecure | Insertamos el parámetro "Ds_Merchant_EMV3DS" en $miObj
$Ds_Merchant_EMV3DS 		= array(
	'addrMatch'				=> $addrMatch,
	'billAddrCity'			=> $billAddrCity,
	'billAddrLine1'			=> $billAddrLine1,
	'billAddrPostCode'		=> $billAddrPostCode,
	'email'					=> $Email,
	'acctInfo'				=> $acctInfo,
);
if ($billAddrLine2 != null){
	$Ds_Merchant_EMV3DS['billAddrLine2']		= $billAddrLine2;
}
if ($mobilePhone != null) {
	$Ds_Merchant_EMV3DS['mobilePhone']			= $mobilePhone;
}
if ($homePhone != null) {
	$Ds_Merchant_EMV3DS['homePhone']			= $homePhone;
}
if ($order['details']['ST']->address_1 != null){
	// $Ds_Merchant_EMV3DS['acctInfo']			= array(
	// 	'shipAddressUsage'					=> $shipAddressUsage,
	// 	'shipAddressUsageInd'				=> $shipAddressUsageInd
	// );
	$Ds_Merchant_EMV3DS['shipAddrCity']		= $shipAddrCity;
	$Ds_Merchant_EMV3DS['shipAddrLine1']	= $shipAddrLine1;
	$Ds_Merchant_EMV3DS['shipAddrPostCode']	= $shipAddrPostCode;
	if ($shipAddrLine2 != null){
		$Ds_Merchant_EMV3DS['shipAddrLine2']	= $shipAddrLine2;	
	}	
}

$Ds_Merchant_EMV3DS 		= json_encode($Ds_Merchant_EMV3DS);

$miObj->setParameter("Ds_Merchant_EMV3DS", $Ds_Merchant_EMV3DS);

?>
