<?php

include_once ('wc-redsys-insite.php');

class WC_Redsys_Order {

    private static $_estado;

	public static function confirmation($gateway, $idOrder, $amount, $dataCapture = null, $transactionType = 1){
        if ($transactionType == RESTConstants::$PREAUTHORIZATION)
		    return self::transaction($gateway, $idOrder, RESTConstants::$CONFIRMATION, $amount, $dataCapture);
        else if ($transactionType == RESTConstants::$VALIDATION)
            return self::transaction($gateway, $idOrder, RESTConstants::$VALIDATION_CONFIRMATION, $amount, $dataCapture);
    }

	public static function refund($gateway, $idOrder, $amount){
        $orderDetails = self::getOrderDetails($idOrder);
        if($orderDetails['transaction_type'] == RESTConstants::$PREAUTHORIZATION){
            $orderConfirmationDetails = self::getOrderConfirmationDetails($idOrder);

            $currency_decimals = $gateway->decimales_moneda;
            $amount = number_format( (float) ($amount), intval($currency_decimals), '.', '' );
            $amount = str_replace('.','',$amount);
            $amount = floatval($amount);
            
            if(!$orderConfirmationDetails){
                return array(
                    'result' => 0,
                    'error' => 'No se ha encontrado detalles de la orden ' . $idOrder . ' sobre la que se quiere realizar la devolución.'
                );
            
            } else if (!self::refundAmountValidation($idOrder, $orderConfirmationDetails, $amount)) {
                return array(
                    'result' => 0,
                    'error' => 'El importe es incorrecto.'
                );
            }

            $amountRefunded = false;
            foreach($orderConfirmationDetails as $orderConfirmationDetail){
                $rts = $orderConfirmationDetail['rts'];
                $amountToRefund = min($amount, $orderConfirmationDetail['confirmation_amount'] - $orderConfirmationDetail['refund_amount']);
                if($amountToRefund){
                    $response = self::transaction($gateway, $idOrder, RESTConstants::$REFUND, $amountToRefund/pow(10, $currency_decimals), null, $rts);

                    if($response['result']){
                        global $wpdb;
                        $wpdb->update(
                            self::getOrderConfirmationTableName(),
                            array(
                                'refund_amount' => $orderConfirmationDetail['refund_amount'] + $amountToRefund
                            ),
                            array( 
                                'id_order' => $idOrder,
                                'rts' => $rts
                            )
                        );
                        $amount -= $amountToRefund;
                        $amountRefunded = true;
                        if(!$amount){
                            return $response;
                        }
                    }else{
                        if($amountRefunded){
                            $response['error'] = "Se ha realizado una devolución parcial correctamente pero ha fallado otra.<br>" . $response['error'];
                        }
                        return $response;
                    }
                }else{
                    $response = array(
                        'result' => 0,
                        'error' => 'El importe es incorrecto'
                    );
                }
            }
            return $response;
        }else{
            return self::transaction($gateway, $idOrder, RESTConstants::$REFUND, $amount);
        }
    }

	public static function cancellation($gateway, $idOrder, $amount, $dataCapture = null){
        return self::transaction($gateway, $idOrder, RESTConstants::$CANCELLATION, $amount, $dataCapture);
    }

	private static function transaction($gateway, $idOrder, $transactionType, $amount = null, $dataCapture = null, $rts = null){
        $orderDetails = self::getOrderDetails($idOrder);

        $idLog = generateIdLog($gateway->activar_log, $gateway->logString, $idOrder . $gateway->fuc, $gateway->tamano_log);

        if(!$orderDetails){
            return array(
                'result' => 0,
                'error' => 'No se encuentra la orden registrada'
            );
        }

        if(!$amount){
            $amount = $orderDetails['grand_total'];
        }

		$currency_decimals = $gateway->decimales_moneda;
        $amount = number_format( (float) ($amount), intval($currency_decimals), '.', '' );
        $amount = str_replace('.','',$amount);
        $amount = floatval($amount);

		$request = new RestOperationMessage();

        if($transactionType == RESTConstants::$CANCELLATION){
            //Anulacion de Pago (45) o Anulacion de Preautorizacion (9)
            $transactionType = $orderDetails['transaction_type'] == RESTConstants::$AUTHORIZATION? RESTConstants::$PAYMENT_CANCELLATION : RESTConstants::$CANCELLATION;
        }

        if($transactionType == RESTConstants::$CONFIRMATION){
            //Si es una confirmacion parcial, utilizamos el tipo de operacion 48
            if($amount < $orderDetails['grand_total']){
                $transactionType = RESTConstants::$PARTIAL_CONFIRMATION;
            }
        }
        
        escribirLog("DEBUG", $idLog, "Se va a realizar una " . self::getTransactionTypeString($transactionType) . " para el pedido " . $orderDetails['redsys_order']);

        if(!self::amountValidation($idOrder, $transactionType, $amount)){
            escribirLog("DEBUG", $idLog, "No supero las validaciones");
            return array(
                'result' => 0,
                'error' => 'El importe es incorrecto'
            );
        }

        try{
            $merchantModule = 'WO-PUR v' . MODULE_VERSION;

            $request->setAmount( $amount );
            $request->setCurrency( $gateway->moneda );
            $request->setMerchant( $gateway->fuc );
            $request->setTerminal( $gateway->terminal );
            $request->setOrder( $orderDetails['redsys_order'] );
            $request->setTransactionType( $transactionType );
            $request->addParameter( "Ds_Merchant_Module", $merchantModule );
            $request->setAmount( $amount );

            if(!is_null($rts) and $rts > 0){
                escribirLog("DEBUG", $idLog, "La operación se va a realizar usando el RTS " . $rts);
                $request->addParameter( "Ds_Merchant_Rts", $rts );
            }

            escribirLog("DEBUG", $idLog, str_replace( array("\r", "\n", "<?xml version=\"1.0\"?>"), '', $request->toXML() ) );   

            $service = new RESTOperationService ( $gateway->claveFirma, $gateway->entorno );
            $result = $service->sendOperation ( $request, $idLog );
        }catch(Exception $e){
            return array(
                'result' => 0,
                'error' => $e->getMessage()
            );
        }

        if($result->getResult () == RESTConstants::$RESP_LITERAL_OK){
            escribirLog("DEBUG", $idLog, "La " . self::getTransactionTypeString($transactionType) . " se ha procesado correctamente");

            $rts = null;
            if ($transactionType == RESTConstants::$PARTIAL_CONFIRMATION)
                $rts = $result->getOperation()->getRts();
            else if ($transactionType == RESTConstants::$CONFIRMATION || $transactionType == RESTConstants::$VALIDATION_CONFIRMATION)
                $rts = -1;

            self::updateOrderAmount($idOrder, $transactionType, $amount, $rts, $idLog);
        }else{
            escribirLog("DEBUG", $idLog, "Ha habido un problema al procesar la " . self::getTransactionTypeString($transactionType) . ", contacte con su entidad o revise el Portal de Administracion del TPV Virtual");
        }

        $response = array(
            'result' => $result->getResult () == RESTConstants::$RESP_LITERAL_OK ? 1 : 0,
        );

        if(!$response['result']){
            /** Análisis de respuesta del SIS. */
            $respuesta = $result->getApiCode();

            $erroresSIS = array();
            $errorBackofficeSIS = "";

            include 'erroresSIS.php';

            if (array_key_exists($respuesta, $erroresSIS)) {
                
                $errorBackofficeSIS  = $respuesta;
                $errorBackofficeSIS .= ' - '.$erroresSIS[$respuesta] . '.';
            
            } else {

                $errorBackofficeSIS = "Código de respuesta " . $respuesta . " no registrado en el módulo. Consulte el Portal de Administración del TPV Virtual.";
            }
            $response['error'] = $errorBackofficeSIS;
        }

		return $response;
    }

    private static function getTransactionTypeString($transactionType){
        switch($transactionType){
            case RESTConstants::$CONFIRMATION:
                return "CONFIRMACIÓN";
            case RESTConstants::$VALIDATION_CONFIRMATION:
                return "CONFIRMACIÓN DE AUTENTICACIÓN";
            case RESTConstants::$REFUND:
                return "DEVOLUCIÓN";
            case RESTConstants::$PARTIAL_CONFIRMATION:
                return "CONFIRMACIÓN PARCIAL";
            case RESTConstants::$PAYMENT_CANCELLATION:
            case RESTConstants::$CANCELLATION:
                return "ANULACIÓN";
        }
        return "TRANSACCIÓN " . $transactionType;
    }

    private static function updateOrderAmount($idOrder, $transactionType, $amount, $rts = null, $idLog = null){
		global $wpdb;

        $orderDetails = self::getOrderDetails($idOrder);
            
        $data = array();
        switch($transactionType){
            case RESTConstants::$CONFIRMATION:
            case RESTConstants::$VALIDATION_CONFIRMATION:
            case RESTConstants::$PARTIAL_CONFIRMATION:
                $data = array(
                    'confirmation_amount' => $orderDetails['confirmation_amount'] + $amount
                );
                break;
            case RESTConstants::$REFUND:
                $data = array(
                    'refund_amount' => $orderDetails['refund_amount'] + $amount
                );
                break;
            case RESTConstants::$PAYMENT_CANCELLATION:
            case RESTConstants::$CANCELLATION:
                $data = array(
                    'cancellation_amount' => $orderDetails['cancellation_amount'] + $amount
                );
                break;
        }

        $wpdb->update(
            self::getOrderTableName(),
            $data,
            array( 
                'id_order' => $idOrder
            )
        );

        if(!is_null($rts)){
            $wpdb->insert(
                self::getOrderConfirmationTableName(),
                array(
                    'id_order' => $idOrder,
                    'rts' => $rts,
                    'confirmation_amount' => $amount,
                    'refund_amount' => 0
                )
            );
        }

        self::updateOrderStatus($idOrder, $transactionType, $idLog);
    }

    private static function updateOrderStatus($idOrder, $transactionType, $idLog = null){
        $orderDetails = self::getOrderDetails($idOrder);
        $order = new WC_Order($idOrder);
        $estado = null;

        switch($transactionType) {
            case RESTConstants::$CONFIRMATION:
            case RESTConstants::$VALIDATION_CONFIRMATION:
                $order->payment_complete();
                break;
        }

        if($orderDetails['cancellation_amount'] == $orderDetails['grand_total']){
            $estado = "cancelled";
        }

        if($estado){
            escribirLog("DEBUG", $idLog, "Se actualiza el estado de la orden " . $idOrder . " a " . $estado, null, __METHOD__);
            $order->update_status($estado,__( '[REDSYS] La ' . self::getTransactionTypeString($transactionType) . ' se ha procesado correctamente', 'woocommerce' ));
        
        } else {

            if ($transactionType > 1 and $transactionType != 7) $order->add_order_note(__( '[REDSYS] La ' . self::getTransactionTypeString($transactionType) . ' se ha procesado correctamente', 'woocommerce' ));
        }

        $resultPorConfirmar = number_format( ($orderDetails['grand_total'] - $orderDetails['confirmation_amount'] - $orderDetails['cancellation_amount']) / 100, 2, "," , "." );
        $resultConfirmado = number_format( ($orderDetails['confirmation_amount'] - $orderDetails['refund_amount']) / 100, 2, "," , "." );
        $resultAnulado = number_format( $orderDetails['cancellation_amount'] / 100, 2, "," , "." );
        $resultDevuelto = number_format( $orderDetails['refund_amount'] / 100, 2, "," , "." );

        if($orderDetails['transaction_type'] == RESTConstants::$AUTHORIZATION)
            return;

        $order->add_order_note( __('Estado de la orden.
        <br>
            POR CONFIRMAR: ' . $resultPorConfirmar . '€
            CONFIRMADO: ' . $resultConfirmado . '€
            ANULADO: ' . $resultAnulado . '€
            DEVUELTO: ' . $resultDevuelto .'€'
            , 'woocommerce'));

    }

    private static function amountValidation($idOrder, $transactionType, $amount){
		global $wpdb;

        $orderDetails = self::getOrderDetails($idOrder);

        switch($transactionType){
            case RESTConstants::$CONFIRMATION:
            case RESTConstants::$PARTIAL_CONFIRMATION:
            case RESTConstants::$PAYMENT_CANCELLATION:
            case RESTConstants::$CANCELLATION:
                $amountNotConfirmed = $orderDetails['grand_total'] - $orderDetails['confirmation_amount'] - $orderDetails['cancellation_amount'];
                if($amount > $amountNotConfirmed){
                    return false;
                }
                break;
            case RESTConstants::$REFUND:
                if($amount > $orderDetails['confirmation_amount'] - $orderDetails['refund_amount']){
                    return false;
                }
                break;
        }

        return true;
    }

    private static function refundAmountValidation($idOrder, $orderConfirmationDetails, $amount){
        $amountToRefund = 0;

        foreach($orderConfirmationDetails as $orderConfirmationDetail){
            $amountToRefund += $orderConfirmationDetail['confirmation_amount'] - $orderConfirmationDetail['refund_amount'];
        }

        return $amountToRefund >= $amount;
    }

    private static function removeEmptyFields($array){
        foreach ($array as $key => & $value) {
            if (is_array($value)) {
                $value = self::removeEmptyFields($value);
            }else{
                if ( $value == '') {
                    unset($array[$key]);
                }
            }
        }
        unset($value);
    
        return $array;
    }

    public static function saveOrderDetails($idOrder, $redsysOrder, $transactionType, $amount, $idLog = null){
		global $wpdb;

        if($idOrder!=null && self::checkOrderTable()){
            $oldRedsysOrder=self::getRedsysOrder($idOrder);
            
            if($oldRedsysOrder==null){
				$wpdb->insert(
					self::getOrderTableName(),
					array(
                        'id_order' => $idOrder,
                        'redsys_order' => substr($redsysOrder, 0, 20),
                        'transaction_type' => $transactionType,
                        'grand_total' => $amount,
                        'confirmation_amount' => $transactionType == RESTConstants::$AUTHORIZATION ? $amount : 0,
					)
				);
            }else{
				$wpdb->update(
					self::getOrderTableName(),
					array(
						'redsys_order' => substr($redsysOrder, 0, 20),
                        'transaction_type' => $transactionType,
                        'grand_total' => $amount,
                        'confirmation_amount' => $transactionType == RESTConstants::$AUTHORIZATION ? $amount : 0,
					),
					array( 
						'id_order' => $idOrder
                    )
				);
            }
            self::updateOrderStatus($idOrder, $transactionType, $idLog);
        }
    }

    public static function getOrderId($redsysOrder){
		if(self::checkOrderTable()){
			global $wpdb;

			$order=$wpdb->get_results( "SELECT * FROM ".self::getOrderTableName()." WHERE redsys_order='".$redsysOrder."';", ARRAY_A  );
			if(sizeof($order)>0)
				return $order[0]["id_order"];
		}
		return null;
    }

    public static function getRedsysOrder($idOrder){
		if(self::checkOrderTable()){
			global $wpdb;
			
			$order=$wpdb->get_results( "SELECT * FROM ".self::getOrderTableName()." WHERE id_order=".$idOrder.";", ARRAY_A  );
			if(sizeof($order)>0)
				return $order[0]["redsys_order"];
		}
		return null;
    }

    public static function getOrderDetails($idOrder){
		if(self::checkOrderTable()){
			global $wpdb;
			
			$order=$wpdb->get_results( "SELECT * FROM ".self::getOrderTableName()." WHERE id_order=".$idOrder.";", ARRAY_A  );
			if(sizeof($order)>0)
				return $order[0];
		}
		return null;
    }

    public static function getOrderConfirmationDetails($idOrder){
		if(self::checkOrderConfirmationTable()){
			global $wpdb;
			
			$order=$wpdb->get_results( "SELECT * FROM ".self::getOrderConfirmationTableName()." WHERE id_order=".$idOrder.";", ARRAY_A  );
			if(sizeof($order)>0)
				return $order;
		}
		return null;
    }

	public static function checkOrderTable(){
		global $wpdb;

        $sqlQueryCheckTable = "
            SELECT 1
            FROM information_schema.columns 
            WHERE table_name = '".self::getOrderTableName()."' AND column_name = 'grand_total';
        ";
		
        $exists = sizeof($wpdb->get_results( $sqlQueryCheckTable ))>0;

        if(!$exists){
            self::createOrderTable();
            $exists = sizeof($wpdb->get_results( $sqlQueryCheckTable ))>0;
        }

        return $exists && self::checkOrderConfirmationTable();
	}

	public static function checkOrderConfirmationTable(){
		global $wpdb;

        $sqlQueryCheckTable = "
            SELECT 1
            FROM information_schema.columns 
            WHERE table_name = '".self::getOrderConfirmationTableName()."' AND column_name = 'confirmation_amount';
        ";
		
        $exists = sizeof($wpdb->get_results( $sqlQueryCheckTable ))>0;

        if(!$exists){
            self::createOrderConfirmationTable();
            $exists = sizeof($wpdb->get_results( $sqlQueryCheckTable ))>0;
        }

        return $exists;
    }

	public static function createOrderTable(){
		global $wpdb;

		$charset_collate = $wpdb->get_charset_collate();

		$sql = "CREATE TABLE `".self::getOrderTableName()."` (
            `id_order` INT NOT NULL PRIMARY KEY,
            `redsys_order` VARCHAR(20) NOT NULL,
            `transaction_type` INT NOT NULL,
            `grand_total` float NOT NULL DEFAULT 0,
            `confirmation_amount` float NOT NULL DEFAULT 0,
            `refund_amount` float NOT NULL DEFAULT 0,
            `cancellation_amount` float NOT NULL DEFAULT 0,
            INDEX (`id_order`)
        ) $charset_collate;";
		require_once( ABSPATH . 'wp-admin/includes/upgrade.php' );
		$res = dbDelta( $sql );
	}

	public static function createOrderConfirmationTable(){
		global $wpdb;

        $charset_collate = $wpdb->get_charset_collate();

		$sql = "CREATE TABLE `".self::getOrderConfirmationTableName()."` (
            `id_order` INT NOT NULL,
            `rts` VARCHAR(40) NOT NULL,
            `confirmation_amount` float NOT NULL DEFAULT 0,
            `refund_amount` float NOT NULL DEFAULT 0,
            PRIMARY KEY (`id_order`, `rts`),
            INDEX (`id_order`, `rts`)
        ) $charset_collate;";
		require_once( ABSPATH . 'wp-admin/includes/upgrade.php' );
		$res = dbDelta( $sql );
    }

	public static function dropOrderTable(){
		global $wpdb;
		
		$sql = "'DROP TABLE `".self::getOrderTableName()."`'";
		require_once( ABSPATH . 'wp-admin/includes/upgrade.php' );
		dbDelta( $sql );
	}

    public static function dropOrderConfirmationTable(){
        global $wpdb;

		$sql = "'DROP TABLE `".self::getOrderConfirmationTableName()."`'";
		require_once( ABSPATH . 'wp-admin/includes/upgrade.php' );
		dbDelta( $sql );
    }

    public static function getOrderTableName(){
		global $wpdb;
		return $wpdb->prefix."redsys_order";
    }

    public static function getOrderConfirmationTableName(){
		global $wpdb;
		return $wpdb->prefix."redsys_order_confirmation";
    }

}