/*
 * Decompiled with CFR 0.152.
 */
package sis.redsys.api;

import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Cipher;
import javax.crypto.Mac;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import sis.redsys.api.Utils;

public class Signature {
    private static final byte[] IV16 = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private static String CIPHER_AES_NAME = "AES/CBC/PKCS5PADDING";
    private static int CIPHER_AES_KEY_LEN = 16;

    private static byte[] cifrarAESCBC(String clave, String datos) {
        String encryptedDataInBase64 = "";
        try {
            IvParameterSpec ivSpec = new IvParameterSpec(IV16);
            SecretKeySpec secretKey = new SecretKeySpec(Signature.fixKey(clave).getBytes(StandardCharsets.UTF_8), "AES");
            Cipher cipher = Cipher.getInstance(CIPHER_AES_NAME);
            cipher.init(1, (Key)secretKey, ivSpec);
            byte[] encryptedData = cipher.doFinal(datos.getBytes());
            encryptedDataInBase64 = Utils.encodeB64String(encryptedData);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
        return encryptedDataInBase64.getBytes();
    }

    private static String fixKey(String key) {
        if (key.length() < CIPHER_AES_KEY_LEN) {
            int numPad = CIPHER_AES_KEY_LEN - key.length();
            for (int i = 0; i < numPad; ++i) {
                key = key + "0";
            }
            return key;
        }
        if (key.length() > CIPHER_AES_KEY_LEN) {
            return key.substring(0, CIPHER_AES_KEY_LEN);
        }
        return key;
    }

    private static byte[] mac512(String dsMerchantParameters, byte[] secretKo) throws NoSuchAlgorithmException, InvalidKeyException, IllegalStateException, UnsupportedEncodingException {
        Mac sha512HMAC = Mac.getInstance("HmacSHA512");
        SecretKeySpec secretKey = new SecretKeySpec(secretKo, "HmacSHA512");
        sha512HMAC.init(secretKey);
        byte[] hash = sha512HMAC.doFinal(dsMerchantParameters.getBytes("UTF-8"));
        return hash;
    }

    public static String createMerchantSignature(String claveComercio, String datos, String numPedido) throws InvalidKeyException, NoSuchAlgorithmException, IllegalStateException, UnsupportedEncodingException {
        byte[] secretKo = Signature.cifrarAESCBC(claveComercio, numPedido);
        byte[] hash = Signature.mac512(datos, secretKo);
        return Utils.encodeB64UrlSafeString(hash);
    }

    public static void checkSignatures(String sig1, String sig2) throws SecurityException {
        if (sig1 != null && !sig1.equalsIgnoreCase(sig2)) {
            throw new SecurityException("Integrity failure. The received signature does not match the calculated one.");
        }
    }
}

