/*
 * Decompiled with CFR 0.152.
 */
package sis.redsys.api;

import java.io.UnsupportedEncodingException;
import java.security.SecureRandom;
import java.util.Base64;

public class Utils {
    private static final SecureRandom random = new SecureRandom();

    public static String generateRandomString(int length) {
        String chars = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
        StringBuilder sb = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            int index = random.nextInt("abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789".length());
            sb.append("abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789".charAt(index));
        }
        return sb.toString();
    }

    public static byte[] encodeB64(byte[] data) {
        return Base64.getEncoder().encode(data);
    }

    public static byte[] encodeB64UrlSafe(byte[] data) {
        return Base64.getUrlEncoder().withoutPadding().encode(data);
    }

    public static String encodeB64String(byte[] data) throws UnsupportedEncodingException {
        return Base64.getEncoder().encodeToString(data);
    }

    public static String encodeB64UrlSafeString(byte[] data) throws UnsupportedEncodingException {
        return Base64.getUrlEncoder().withoutPadding().encodeToString(data);
    }

    public static byte[] decodeB64(byte[] data) {
        return Base64.getDecoder().decode(data);
    }

    public static byte[] decodeB64UrlSafe(byte[] data) {
        return Base64.getUrlDecoder().decode(data);
    }

    public static String decodeB64String(byte[] data) throws UnsupportedEncodingException {
        return new String(Utils.decodeB64(data), "UTF-8");
    }

    public static String decodeB64UrlSafeString(byte[] data) throws UnsupportedEncodingException {
        return new String(Utils.decodeB64UrlSafe(data), "UTF-8");
    }
}

