package es.redsys.rest.test.example;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;

import es.redsys.rest.api.constants.RestConstants.Environment;
import es.redsys.rest.api.constants.RestConstants.TransactionType;
import es.redsys.rest.api.model.RestResponse;
import es.redsys.rest.api.model.message.RestAuthenticationRequestMessage;
import es.redsys.rest.api.model.message.RestInitialRequestMessage;
import es.redsys.rest.api.model.message.RestOperationMessage;
import es.redsys.rest.api.service.RestService;
import es.redsys.rest.api.service.impl.RestAuthenticationRequestService;
import es.redsys.rest.api.service.impl.RestInitialRequestService;
import es.redsys.rest.api.service.impl.RestOperationService;

/** 
 * Los ejemplos proporcionados en el API son una representación de como utilizar 
 * las diferentes funciones del API y no se deben utilizar tal cual se proporcionan,
 * ya que no contienen validaciones de seguridad y de negocio propias de la 
 * implementación de cada comercio. Redsys no se hace responsable de la utilización
 * de estos ejemplos en el servidor del comercio tal cual se proporcionan. 
 * 
 * 
 * The examples provided in the API are a representation of how to use
 * the different API functions and should not be used as provided,
 * since they do not contain security and business validations typical of the
 * implementation of each trade. Redsys is not responsible for the use
 * of these examples on the merchant's server as provided.
 */

/**
 * Example Class for testing purposes
 * @author Redsys
 */
public class ExampleDCCDirectPayment {
		
	/**
	 * Method for random order number
	 * @param args not used in this testing example
	 * @throws IOException 
	 */
	private static final String ALPHA_NUMERIC_STRING = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
		public static String randomOrderID() {
			StringBuilder orderID = new StringBuilder();
			for(int i = 0 ; i < 10 ; ++i) {
				orderID.append(ALPHA_NUMERIC_STRING.charAt(ThreadLocalRandom.current().nextInt(ALPHA_NUMERIC_STRING.length())));
			}
		return orderID.toString();
	}
				
	/**
	 * Main method for testing purposes
	 * @param args not used in this testing example
	 * @throws IOException 
	 */
	public static void main(String [] args) throws IOException {
		String orderID=randomOrderID();
		initialOperation(orderID);
	}

	
	/**
	 * Method for a initial DCC operation request
	 */
	private static void initialOperation(String orderID) {
		
		RestInitialRequestMessage cardDataInfoRequest = new RestInitialRequestMessage();
		// Operation mandatory data
		cardDataInfoRequest.setAmount("123"); // i.e. 1,23 (decimal point depends on currency code)
		cardDataInfoRequest.setCurrency("978"); // ISO-4217 numeric currency code
		cardDataInfoRequest.setMerchant("999008881");
		cardDataInfoRequest.setTerminal("20");
		cardDataInfoRequest.setOrder(orderID);
		cardDataInfoRequest.setTransactionType(TransactionType.AUTHORIZATION);
		cardDataInfoRequest.setCardNumber("5424180805648190");
		cardDataInfoRequest.setCardExpiryDate("3412");
		cardDataInfoRequest.setCvv2("123");
		
		// Other optional parameters example can be added by "addParameter" method
		cardDataInfoRequest.addParameter("DS_MERCHANT_PRODUCTDESCRIPTION", "Prueba de pago DCC con directPayment");
		
		//Method to ask about DCC card data
		cardDataInfoRequest.demandDCCinfo();
		
		// Response object for the Initial Request
		RestResponse response = null;
		try {
			// Service setting (Signature and Environment)
			RestService service = new RestInitialRequestService("sq7HjrUOBfKmC576ILgskD5srU870gJ7", Environment.SANDBOX);
			//Send the operation and catch the response
			response = service.sendOperation(cardDataInfoRequest);
			// Response analysis
			System.out.println(response.toString());
			
			//Method the gives the request Result (OK/KO/AUT)
			switch (response.getResult()) {
				case OK:
					//In this case the operation was ok and PSD2= "N", so authentication is not needed but its possible to make authentication
					System.out.println("Operation was OK");
					
					//To get DCC information
					String dccCurrency = response.getDCCCurrency();
					String dccAmount = response.getDCCAmount();
					
					//In this case the commerce can choose which kind of operation want to use
					directPaymentDCCOperation(orderID, dccCurrency, dccAmount);
				break;
				case KO: 
					//Operation error
					System.out.println("Operation was not OK"); 
				break;
				default:
					System.out.println("Aquí no debemos entrar!!!!");
			}
		} catch (Exception e) {
			// Error treatment
			e.printStackTrace();
		}
	 }
	
	
	/**
	 * Method for a directPayment operation request.
	 * @param orderID
	 */
	private static void directPaymentDCCOperation(String orderID, String dccCurrency, String dccAmount ) {
		RestOperationMessage request = new RestOperationMessage();
		// Operation mandatory data
		request.setAmount("123"); // i.e. 1,23 (decimal point depends on currency code)
		request.setCurrency("978"); // ISO-4217 numeric currency code
		request.setMerchant("999008881");
		request.setTerminal("20");
		request.setOrder(orderID);
		request.setTransactionType(TransactionType.AUTHORIZATION);
		request.setCardNumber("5424180805648190");
		request.setCardExpiryDate("3412");
		request.setCvv2("123");
		
		
		//To add DCC info to the request
		request.dccOperation(dccCurrency, dccAmount);
		
		// Other optional parameters example can be added by "addParameter" method
		request.addParameter("DS_MERCHANT_PRODUCTDESCRIPTION", "Prueba de pago DCC con directPayment");
		
		//Method for a direct payment request (without authentication)
		request.useDirectPayment();
		
		// Response object
		RestResponse response = null;
		try {
			// Service setting (Signature, Environment, type of payment)
			RestService service = new RestOperationService("sq7HjrUOBfKmC576ILgskD5srU870gJ7", Environment.SANDBOX);
			response = service.sendOperation(request);
			// Response analysis
			System.out.println(response.toString());
			switch (response.getResult()) {
				case OK: System.out.println("Operation was OK"); break;
				case AUT: System.out.println("Operation requires authentication"); break;
				default: System.out.println("Operation was not OK"); break;
			}
		} catch (Exception e) {
			// Error treatment
			e.printStackTrace();
		}
	}
}