package es.redsys.rest.test.example;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;

import es.redsys.rest.api.constants.RestConstants;
import es.redsys.rest.api.constants.RestConstants.Environment;
import es.redsys.rest.api.constants.RestConstants.Operation;
import es.redsys.rest.api.constants.RestConstants.TransactionType;
import es.redsys.rest.api.model.RestResponse;
import es.redsys.rest.api.model.element.RestOperationElement;
import es.redsys.rest.api.model.message.RestAuthenticationRequestMessage;
import es.redsys.rest.api.model.message.RestInitialRequestMessage;
import es.redsys.rest.api.model.message.RestOperationMessage;
import es.redsys.rest.api.model.message.RestResponseMessage;
import es.redsys.rest.api.service.RestService;
import es.redsys.rest.api.service.impl.RestAuthenticationRequestService;
import es.redsys.rest.api.service.impl.RestInitialRequestService;
import es.redsys.rest.api.service.impl.RestOperationService;

/** 
 * Los ejemplos proporcionados en el API son una representación de como utilizar 
 * las diferentes funciones del API y no se deben utilizar tal cual se proporcionan,
 * ya que no contienen validaciones de seguridad y de negocio propias de la 
 * implementación de cada comercio. Redsys no se hace responsable de la utilización
 * de estos ejemplos en el servidor del comercio tal cual se proporcionan. 
 * 
 * 
 * The examples provided in the API are a representation of how to use
 * the different API functions and should not be used as provided,
 * since they do not contain security and business validations typical of the
 * implementation of each trade. Redsys is not responsible for the use
 * of these examples on the merchant's server as provided.
 */

/**
 * Example Class for testing purposes
 * @author Redsys
 */

public class Example3DSecureV2ExemptionLWV {
		
	/**
	 * Method for random order number
	 * @param args not used in this testing example
	 * @throws IOException 
	 */
	private static final String ALPHA_NUMERIC_STRING = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
		public static String randomOrderID() {
			StringBuilder orderID = new StringBuilder();
			for(int i = 0 ; i < 10 ; ++i) {
				orderID.append(ALPHA_NUMERIC_STRING.charAt(ThreadLocalRandom.current().nextInt(ALPHA_NUMERIC_STRING.length())));
			}
		return orderID.toString();
	}
				
	/**
	 * Main method for testing purposes
	 * @param args not used in this testing example
	 * @throws IOException 
	 */
	public static void main(String [] args) throws IOException {
		String orderID=randomOrderID();
		inititalOperation(orderID);
	}

	
	/**
	 * Method for a initial operation request that gives the card data info and exemptions
	 */
	private static void inititalOperation(String orderID) {
		
		String protocolVersion = "";
		String threeDSServerTransID = "";
		String threeDSMethodURL = "";
		
		RestInitialRequestMessage cardDataInfoRequest = new RestInitialRequestMessage();
		// Operation mandatory data
		cardDataInfoRequest.setAmount("123"); // i.e. 1,23 (decimal point depends on currency code)
		cardDataInfoRequest.setCurrency("978"); // ISO-4217 numeric currency code
		cardDataInfoRequest.setMerchant("999008881");
		cardDataInfoRequest.setTerminal("20");
		cardDataInfoRequest.setOrder(orderID);
		cardDataInfoRequest.setTransactionType(TransactionType.AUTHORIZATION);
		cardDataInfoRequest.setCardNumber("4548810000000003");
		cardDataInfoRequest.setCardExpiryDate("3412");
		cardDataInfoRequest.setCvv2("123");
		
		// Other optional parameters example can be added by "addParameter" method
		cardDataInfoRequest.addParameter("DS_MERCHANT_PRODUCTDESCRIPTION", "Prueba de pago usando exenciones");
		
		//Method to ask about card information data
		cardDataInfoRequest.demandCardData();
		
		//Method to ask about the exemption Info
		cardDataInfoRequest.demandExemptionInfo();
		
		
		// Response object for the Initial Request
		RestResponse response = null;
		try {
			// Service setting (Signature and Environment)
			RestService service = new RestInitialRequestService("sq7HjrUOBfKmC576ILgskD5srU870gJ7", Environment.SANDBOX);
			//Send the operation and catch the response
			response = service.sendOperation(cardDataInfoRequest);
			// Response analysis
			System.out.println(response.toString());
			//Method the gives the request Result (OK/KO/AUT)
			switch (response.getResult()) {
				case OK:
					//In this case the operation was ok and PSD2= "N", so authentication is not needed but its possible to make authentication
					System.out.println("Operation was OK");
					//In this case the commerce can choose which kind of operation want to use
					//directPaymentOperation (example of this operation in InsiteExampleDirectPayment.java)
					//or authenticationOperation (recommended)
					authenticationOperation(orderID, protocolVersion, threeDSServerTransID, threeDSMethodURL);
				break;
				case AUT: 
					//In this case the operation was ok and PSD2= "Y" and return the protocolVersion parameter
					System.out.println("Operation requires authentication"); 
					//Method to catch the protocolVersion (Required for authentication Request)
					protocolVersion = response.protocolVersionAnalysis();
					//Method to catch the threeDSInfo value
					String threeDSInfo = response.getThreeDSInfo();
					//Because the protocolVersion in this example is 2.X.0, its required to catch two mandatory Parameters in the response:
					threeDSServerTransID = response.getThreeDSServerTransID();
					threeDSMethodURL = response.getThreeDSMethodURL();
					//Method to catch the Exemption List
					String exemptionList = response.getExemption();
					System.out.println("The commerce can use Exemption: " + exemptionList);
					//Ones we catch the parameters, we must make the authenticationRequest
					authenticationOperation(orderID, protocolVersion, threeDSServerTransID, threeDSMethodURL);
				break;
				case KO: 
					System.out.println("Operation was not OK"); 
				break;
				default:
					System.out.println("Aquí no debemos entrar!!!!");
			}
		} catch (Exception e) {
			// Error treatment
			e.printStackTrace();
		}
	 }
	
	
	/**
	 * Method for a authentication operation request. This request depend on the initial request parameter "protocolVersion"
	 * @param orderID 
	 * @param protocolVersion
	 * @param threeDSMethodURL 
	 * @param threeDSServerTransID 
	 */
	private static void authenticationOperation(String orderID, String protocolVersion, String threeDSServerTransID, String threeDSMethodURL) {
		
		RestOperationMessage operationRequest = new RestOperationMessage();
		
		// Operation mandatory data
		operationRequest.setAmount("123"); // i.e. 1,23 (decimal point depends on currency code)
		operationRequest.setCurrency("978"); // ISO-4217 numeric currency code
		operationRequest.setMerchant("999008881");
		operationRequest.setTerminal("20");
		operationRequest.setOrder(orderID);
		operationRequest.setTransactionType(TransactionType.AUTHORIZATION);
		operationRequest.setCardNumber("4548810000000003");
		operationRequest.setCardExpiryDate("3412");
		operationRequest.setCvv2("123");
		
		// Other optional parameters example can be added by "addParameter" method
		operationRequest.addParameter("DS_MERCHANT_PRODUCTDESCRIPTION", "Prueba de pago usando exenciones");
	
		//Method to use and exemption, in this case we use the MIT Exemption
		operationRequest.setExemption(RestConstants.REQUEST_MERCHANT_EXEMPTION_VALUE_LWV);
		
		//To get these authenticationRequest parameters values, the commerce needs to implement the 3DSMethod Request (consult the rest connection guide)
		//Each operation has its own values for the parameters values and the commerce must catch them
		//THIS is only an example of the values. 
		
		String browserAcceptHeader = "text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8,application/json";
		String browserUserAgent = "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/71.0.3578.98 Safari/537.36";
		String browserJavaEnable = "false";
		String browserJavaScriptEnabled = "false";
		String browserLanguage = "ES-es";
		String browserColorDepth = "24";
		String browserScreenHeight = "1250";
		String browserScreenWidth = "1320";
		String browserTZ = "52";
		threeDSServerTransID = "8de84430-3336-4ff4-b18d-f073b546ccea";
		String notificationURL= "https://comercio-inventado.es/recibe-respuesta-autenticacion";
		String threeDSCompInd = "Y";
		
		//Method that can be use to add the return parameters to the authentication request for protocolVersion 2.X.0
		operationRequest.setEMV3DSParamsV2(protocolVersion, browserAcceptHeader, browserUserAgent, browserJavaEnable, browserJavaScriptEnabled, browserLanguage, browserColorDepth, browserScreenHeight, browserScreenWidth, browserTZ, threeDSServerTransID, notificationURL, threeDSCompInd);
		
		// Response object for the authenticacionRequest
		RestResponse response = null;
			try {
				// Service setting (Signature and Environment)
					RestService service = new RestOperationService("sq7HjrUOBfKmC576ILgskD5srU870gJ7", Environment.SANDBOX);
					//Send the operation and catch the response
					response = service.sendOperation(operationRequest);
					// Response analysis
					System.out.println(response.toString());
					//Depending on the response, its nedeed to finish or to make another step
					//Method the gives the request Result (OK/KO/AUT)
					switch (response.getResult()) {
						case OK:
							//This is a frictionless response. In this case the operation was ok and the api return the final operation response
							System.out.println("Operation was OK");
						break;
						case KO: 
							System.out.println("Operation was not OK"); 
						break;
						default:
							System.out.println("Aquí no debemos entrar!!!!");
							
					}} catch (Exception e) {
					// Error treatment
					e.printStackTrace();
				}
	}
	
	
}
	