package es.redsys.rest.api.utils;

import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import org.apache.xerces.parsers.DOMParser;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;


public class RestTransformUtils {
	public static Document parseDocument(final String input) throws Exception {
		StringReader reader = new StringReader(input);
		DOMParser parser = new DOMParser();
		InputSource inputSource = new InputSource(reader);
		parser.parse(inputSource);
		reader.close();
		return parser.getDocument();
	}

	public static String getElementValue(Document doc, String elementName) {
		String v;
		Element e = doc.getDocumentElement();
		try {
			StringTokenizer stk = new StringTokenizer(elementName, "/");
			while (e != null && stk.hasMoreElements()) {
				NodeList nl = e.getElementsByTagName((String) stk.nextElement());
				if (nl == null || nl.getLength() < 1)
					e = null;
				else
					e = (Element) nl.item(0);
			}
			v = getElementValue(e);
		} catch (NoSuchElementException ex) {
			v = null;
		}
		return v;
	}

	private static String getElementValue(Element e) {
		if (e == null || e.getFirstChild() == null)
			return null;
		else
			return e.getFirstChild().getNodeValue();
	}
	
	public static String createXMLTag(final String tag, final String value) {
		StringBuffer fullTag = new StringBuffer("");
		if (tag != null && value != null && !value.trim().equals("")) {
			fullTag.append("<").append(tag).append(">");
			fullTag.append(value);
			fullTag.append("</").append(tag).append(">");
		}
		return fullTag.toString();
	}
	
	public static Node getNode(String tagName, NodeList nodes) {
	    for ( int x = 0; x < nodes.getLength(); x++ ) {
	        Node node = nodes.item(x);
	        if (node.getNodeName().equalsIgnoreCase(tagName)) {
	            return node;
	        }
	    }
	    return null;
	}
	 
	public static String getNodeValue( Node node ) {
	    NodeList childNodes = node.getChildNodes();
	    for (int x = 0; x < childNodes.getLength(); x++ ) {
	        Node data = childNodes.item(x);
	        if ( data.getNodeType() == Node.TEXT_NODE )
	            return data.getNodeValue();
	    }
	    return "";
	}
	 
	public static String getNodeValue(String tagName, NodeList nodes ) {
	    for ( int x = 0; x < nodes.getLength(); x++ ) {
	        Node node = nodes.item(x);
	        if (node.getNodeName().equalsIgnoreCase(tagName)) {
	            NodeList childNodes = node.getChildNodes();
	            for (int y = 0; y < childNodes.getLength(); y++ ) {
	                Node data = childNodes.item(y);
	                if ( data.getNodeType() == Node.TEXT_NODE )
	                    return data.getNodeValue();
	            }
	        }
	    }
	    return "";
	}
	 
	public static String getNodeAttr(String attrName, Node node ) {
	    NamedNodeMap attrs = node.getAttributes();
	    for (int y = 0; y < attrs.getLength(); y++ ) {
	        Node attr = attrs.item(y);
	        if (attr.getNodeName().equalsIgnoreCase(attrName)) {
	            return attr.getNodeValue();
	        }
	    }
	    return "";
	}
	 
	public static String getNodeAttr(String tagName, String attrName, NodeList nodes ) {
	    for ( int x = 0; x < nodes.getLength(); x++ ) {
	        Node node = nodes.item(x);
	        if (node.getNodeName().equalsIgnoreCase(tagName)) {
	            NodeList childNodes = node.getChildNodes();
	            for (int y = 0; y < childNodes.getLength(); y++ ) {
	                Node data = childNodes.item(y);
	                if ( data.getNodeType() == Node.ATTRIBUTE_NODE ) {
	                    if ( data.getNodeName().equalsIgnoreCase(attrName) )
	                        return data.getNodeValue();
	                }
	            }
	        }
	    }
	    return "";
	}

	public static String createJSONElement(final String tag, final String value, Boolean last){
		StringBuffer element = new StringBuffer("");
		if (tag != null && value != null && !value.trim().equals("")) {
			element.append("\"").append(tag).append("\": ");
			element.append("\"").append(value).append("\"");
			if (!last)
				element.append(",");
		}
		return element.toString();
	}
	
	public static String createJSONElement(final String tag, final Map<?, ?> value, Boolean last) {
		StringBuffer element = new StringBuffer("");
		if (tag != null && value != null) {
			element.append("\"").append(tag).append("\": ");
			element.append(MapToJSON(value));
			if (!last)
				element.append(",");
		}
		
		return element.toString();
	}
	
	public static String JSONToXML(Map<String, String> input) {
		StringBuffer output = new StringBuffer();
		for (Map.Entry<String, String> entry: input.entrySet()) {
			output.append(createXMLTag(entry.getKey(), entry.getValue()));
		}
		return output.toString();
	}
	
	public static String MapToJSON(Map<?, ?> input) {
		StringBuffer output = new StringBuffer("{");
		for (Map.Entry<?, ?> entry : input.entrySet()) {
			output.append(RestTransformUtils.createJSONElement(String.valueOf(entry.getKey()), String.valueOf(entry.getValue()), false));
		}
		if (output.length() > 1) {
			output.setCharAt(output.length() - 1, '}');
		}
		return output.toString();
	}
	
	public static Map<String, String> JSONToMap(String JSONString) {
		return JSONToMap(JSONString, false);
	}
	
	public static String decodeJSONString(String encodedJSONString) {
		byte[] byteArray = RestSignatureUtils.decodeB64(encodedJSONString.getBytes());
		String decodedJSONString = new String(byteArray);
		return decodedJSONString;
	}
	
	public static Map<String, String> JSONToMap(String JSONString, Boolean encoded) {
		if (encoded) {
			JSONString = decodeJSONString(JSONString);
		}
		JSONString = JSONString.replace("[", "").replace("]", "");
		String regex = "\"([^\"]+)\"[ ]?:[ ]?\"([^\"]+)\"";
		Map<String, String> output = new HashMap<String, String>();
		
		Pattern p = Pattern.compile(regex);
		Matcher m = p.matcher(JSONString);
		
		while (m.find()) {
			output.put(m.group(1), m.group(2));
		}
		
		return output;
	}
}
