package es.redsys.rest.api.service.impl;

import java.io.StringReader;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;

import javax.xml.bind.JAXBContext;

import com.fasterxml.jackson.databind.ObjectMapper;

import es.redsys.rest.api.constants.RestConstants;
import es.redsys.rest.api.constants.RestConstants.Environment;
import es.redsys.rest.api.constants.RestConstants.Operation;
import es.redsys.rest.api.model.RestRequest;
import es.redsys.rest.api.model.RestResponse;
import es.redsys.rest.api.model.message.RestAuthenticationRequestMessage;
import es.redsys.rest.api.model.message.RestResponseMessage;
import es.redsys.rest.api.service.RestService;
import es.redsys.rest.api.utils.RestSignatureUtils;
import es.redsys.rest.api.utils.RestTransformUtils;

public class RestAuthenticationRequestService extends RestService {
	
	public RestAuthenticationRequestService(String signature, Environment env) {
		super(signature, env, Operation.TRATAPETICION_REQUEST);
	}
	
	public RestAuthenticationRequestService(String signature, String endpointURL) {
		super(signature, endpointURL);
	}

	@Override
	protected String createRequestMessage(RestRequest message) throws Exception {
		StringBuffer queryString = new StringBuffer();
		Map<String, String> data = new HashMap<String, String>();
		String datosEntradaB64 = createEncodedJsonMessage(message);
		String signature = RestSignatureUtils.createMerchantSignature(getSignatureKey(), datosEntradaB64);
		
		System.out.println("[INFO] JSON a enviar:");
		StringBuilder debugMsg = new StringBuilder("{\n")
			.append("	\"Ds_MerchantParameters\": \"").append(datosEntradaB64).append("\",\n")
			.append("	\"Ds_SignatureVersion\": \"").append(RestConstants.REQUEST_SIGNATUREVERSION_VALUE).append("\",\n")
			.append("	\"Ds_Signature\": \"").append(signature).append("\"\n")
			.append(("}"));
		System.out.println(debugMsg);
		data.put("Ds_MerchantParameters", datosEntradaB64);
		data.put("Ds_SignatureVersion", RestConstants.REQUEST_SIGNATUREVERSION_VALUE);
		data.put("Ds_Signature", signature);
		
		for (Map.Entry<String, String> pair: data.entrySet()) {
			queryString.append(URLEncoder.encode(pair.getKey(), "UTF-8") + "=");
			queryString.append(URLEncoder.encode(pair.getValue(), "UTF-8") + "&");
		}
		
		return queryString.toString();
	}
	
	@Override 
	protected String createEncodedJsonMessage(RestRequest message) throws Exception {
		StringBuffer result = new StringBuffer("");
		RestAuthenticationRequestMessage request = (RestAuthenticationRequestMessage) message;
		
		if (request != null) {
			result.append("{");
			result.append(RestTransformUtils.createJSONElement(RestConstants.REQUEST_MERCHANT_MERCHANTCODE, request.getMerchant(), false));
			result.append(RestTransformUtils.createJSONElement(RestConstants.REQUEST_MERCHANT_TERMINAL, request.getTerminal(), false));
			result.append(RestTransformUtils.createJSONElement(RestConstants.REQUEST_MERCHANT_ORDER, request.getOrder(), false));
			result.append(RestTransformUtils.createJSONElement(RestConstants.REQUEST_MERCHANT_TRANSACTIONTYPE, request.getTransactionType().type(), false));
			result.append(RestTransformUtils.createJSONElement(RestConstants.REQUEST_MERCHANT_CURRENCY, request.getCurrency(), false));
			if (null != request.getParameters()) {
				for (Map.Entry<String, String> entry : request.getParameters().entrySet()) {
					result.append(RestTransformUtils.createJSONElement(entry.getKey(), entry.getValue(), false));
				}
			}
			if (null != request.getEmv()) {
				result.append(RestTransformUtils.createJSONElement(RestConstants.REQUEST_MERCHANT_EMV3DS, request.getEmv(), false));
			}
			if (null != request.getCardNumber()) {
				result.append(RestTransformUtils.createJSONElement(RestConstants.REQUEST_MERCHANT_PAN, request.getCardNumber(), false));
			}
			if (null != request.getCardExpiryDate()) {
				result.append(RestTransformUtils.createJSONElement(RestConstants.REQUEST_MERCHANT_EXPIRYDATE, request.getCardExpiryDate(), false));
			}
			if (null != request.getCvv2()) {
				result.append(RestTransformUtils.createJSONElement(RestConstants.REQUEST_MERCHANT_CVV2, request.getCvv2(), false));
			}
			result.append(RestTransformUtils.createJSONElement(RestConstants.REQUEST_MERCHANT_AMOUNT, request.getAmount(), true));
			result.append("}");
		}
		String tmp = result.toString().replace("\r\n", " ");
		
		ObjectMapper objectMapper = new ObjectMapper();
		Object json = objectMapper.readValue(tmp.getBytes(), Object.class);
		System.out.println("");
		System.out.println("**************************************************************");
		System.out.println("***************      AuthenticationRequest      **************");
		System.out.println("**************************************************************");
		System.out.println("[INFO] Ds_MerchantParameters (antes de codificar):");
		System.out.println(objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString(json));

		return RestSignatureUtils.encodeB64String(tmp.getBytes());
	}
	
	@Override
	protected RestResponse unMarshallResponseMessage(String message) throws Exception {
		StringReader reader = new StringReader(message);
		RestResponse response = (RestResponseMessage) JAXBContext.newInstance(RestResponseMessage.class).createUnmarshaller().unmarshal(reader);
		reader.close();
		return response;
	}
}
